figure1 = figure('Color',[1 1 1],'rend','painters','units','centimeters','pos',[1 1 17 15]);

%%
subplot1 = subplot(2,2,1);        % add first plot in 2 x 2 grid
hold on

%load Data
MyData = esrf120;
yData = cell2mat(MyData(3:end,2:end));
xData =  cell2mat(MyData(3:end,1));
[a,b] = size(yData);
z = 0;
y2Data(1:a,1) = 0;

%smooth data 
for i = 1:b
    xData(1:a,i) = xData(1:a,1);
    z(1:a,i) = i;
    y2Data(1:end,i) = smooth(yData(1:end,i));
end

%surface map
double xq;
double yq;
double vq;
[xq,yq] = meshgrid(min(real(log10(xData))):.1:max(real(log10(xData))),1:1:a);
P = real(log10(xData));
Q = real(log10(y2Data));
vq = griddata(P,z,Q,xq,yq,'natural');

% Create figure
%figure1 = figure('Color',[1 1 1],'rend','painters','pos',[10 10 500 500]);

% Create axes
%%axes1 = axes('Parent',figure1);
hold(subplot1,'on');
set(gca,'color','none')

% Create surf
surfc(xq,yq,vq,'Parent',subplot1,'EdgeAlpha',0.45);

% Create light
light('Parent',subplot1,'Position',[47.94 8.23999999999998 -2],'Style','infinite');

% Create xlabel
xlabel('Q _{log10} (^{-1})');

% Create ylabel
ylabel('Time (minutes)');

% Create zlabel
zlabel({'','I _{log10} (mm^{-1})',''});

% xyz limits 
zlim(subplot1,[min(min(vq)) max(max(vq))+0.1]);
ylim(subplot1,[0 b]);

xmin = real(log10(min(xData)));
xmax = real(log10(max(xData)));
subplot1.XLim(1) = xmin(1,1);
subplot1.XLim(2) = xmax(1,1);

% axes settings 
view(subplot1,[48 8.24]);
box(subplot1,'on');
grid(subplot1,'on');
axis(subplot1,'square');

% Set the remaining axes properties
set(subplot1,'CLim',[-3 0.25],'Projection','perspective');
set(subplot1,'FontSize',8);
colormap jet
%%
subplot2 = subplot(2,2,[2 4]);       % add second plot in 2 x 2 grid
set(subplot2,'FontSize',8);
hold on

i = 1;

x1 = cell2mat(TTCF120(37:end,2));
x2 = cell2mat(TTCF120(38:end,7));

a = 1;
for n = [8 18 28 38 48 58 68];
h(n) = plot(x2,cell2mat(TTCF120(38:end,n))*10^a,'ok','MarkerSize',4);
a = a+.4;
end
a = 1;
for z = [3 13 23 33 43 53 63];
h(z) = plot(x1,cell2mat(TTCF120(37:end,z))*10^a,'LineWidth',1.5);
h(z).Color = [1 0.6 0];
a = a+.4;
end

legend1 = legend([h(3) h(8)],{'stage III fit','scattering'});
legend('boxoff');
set(legend1,'FontSize',8);
% Create xlabel
xla =xlabel('Q (^{-1}) ');

% Create ylabel
yla =ylabel('I(q) (scaled)');

% Uncomment the following line to preserve the X-limits of the axes
 xlim(subplot2,[0.005 0.51]);
% Uncomment the following line to preserve the Y-limits of the axes
 ylim(subplot2,[0.001 10000]);
 
% Set the remaining axes properties
set(subplot2,'LineStyleOrderIndex',2,'XMinorTick','on','XScale','log',...
    'YMinorTick','on','YScale','log');

time = {'1 min','10','20','30','40','50','60'};
a = 1;
b = 1;
for z = [3 13 23 33 43 53 63];
fittext = text(x1(681,1)+0.05,cell2mat(TTCF120(717,z))*10^a,time(b));
fittext.FontSize = 8;
a = a+.4;
b = b+1;
end


set([xla yla gca],'FontSize',8)
yla.Position = [0.0028 10 -1];
% Create textarrow
annotation(figure1,'textarrow',[0.72 0.72],...
    [0.31 0.86],'String',{'time'},'FontSize',8);


%%
subplot3 = subplot(2,2,3);    % add third plot to span positions 3 and 4
set(subplot3,'FontSize',8);

time = cell2mat(calc120(2:end,1));
chi = cell2mat(calc120(2:end,6));
radius = cell2mat(calc120(2:end,11));
frac = cell2mat(calc120(2:end,9));
cutoff = cell2mat(calc120(2:end,7));

%%figure1 = figure('Position',[0 0 500 275]);
hold on
%plot(time,radius,'LineStyle','none','MarkerSize',4,'Marker','o','Color','b');
%plot(time,cutoff,'LineStyle','none','MarkerSize',4,'Marker','o','Color','r');
%[hBx,a1,a2] = plotyy(time,radius,time,frac);
%plotyy(time,cutoff,time,chi);

[ax, p1, p2]=plotyy(time,radius,time,frac);
hold(ax(1),'on')
p3 = plot(ax(1),time,cutoff,'MarkerEdgeColor', [1 0.6 0]);
hold(ax(2),'on')
p4 = plot(ax(2),time,chi,'^','MarkerEdgeColor','g') ;

ylim(ax(1),[0 80]);
ylim(ax(2),[0 2.5]);
set([p1 p2 p3 p4],'LineStyle','none','MarkerSize',5);
p1.Marker = 'o';
p2.Marker = 's';
p3.Marker = 's';
p4.Marker = '^';
p1.MarkerFaceColor = [1 0 0];
p1.MarkerEdgeColor = [0 0 0];
p2.MarkerFaceColor = [0 0 1];
p2.MarkerEdgeColor = [0 0 0];
p3.MarkerFaceColor = [1 0.6 0];
p3.MarkerEdgeColor = [0 0 0];
p4.MarkerFaceColor = [0 1 0];
p4.MarkerEdgeColor = [0 0 0];
p2.Color = [0 0 1];


ax(1).YColor = 'k';
ax(2).YColor = 'k';

xlabel(ax(1),'Time (min)');
ylabel(ax(1),'Size ()');
ylabel(ax(2),'Arbitrary');
set(ax(2),'YTick',[0 0.5 1 1.5 2 2.5]);
set(ax(1),'YTick',[0 10 20 30 40 50 60 70 80]);
set(ax,'FontSize',8);

%ax(1,2).Position = [0.1 0.175 0.65 0.8];

l1 = legend('rfrac','cut-off','df','chi^2');
set(l1,'Location','north','box','off','Orientation','horizontal');
l1.Position(2) = l1.Position(2)+0.05;
l1.Position(1) = l1.Position(1)+0.05;


%%
subplot1.Position = [0.095 0.6 0.4 0.4];
subplot2.Position =[0.6 0.095 0.35 0.875];
subplot3.Position = [0.095 0.095 0.375 0.345];
%-------------------------------------------------------------------------
% Create textbox
annotation(figure1,'textbox',...
    [0.05 0.965 0.05 0.05],...
    'String','A',...
    'LineStyle','none',...
    'FontSize',18,...
    'FitBoxToText','off');

% Create textbox
annotation(figure1,'textbox',...
    [0.525 0.965 0.1 0.05],...
    'String','B',...
    'LineStyle','none',...
    'FontSize',18,...
    'FitBoxToText','off');

% Create textbox
annotation(figure1,'textbox',...
    [0.05 0.475 0.05 0.05],...
    'String','C',...
    'LineStyle','none',...
    'FontSize',18,...
    'FitBoxToText','off');
%-------------------------------------------------------------------------


set(figure1,'PaperPositionMode','auto');
set(figure1,'PaperSize',[figure1.PaperPosition(3) figure1.PaperPosition(4)]);